## Supplementary Codes for Scalable and Robust Multi-Bit Spintronic Synapses for Analog In-Memory Computing

**Kshemal K. Gupte Sohan Salahuddin Mugdho Cheng Wang**

Iowa State University

## Hardware Evaluation Section
## Run Instructions

This section contains simplified guide for running the hardware evaluation experiments

## Using Docker

We provide a docker with built-in tools for you to get started

- Make a copy of the provided template docker compose file: `cp docker-compose.yaml.template docker-compose.yaml`
- Examine the instructions in `docker-compose.yaml` to setup the docker correctly, e.g., setup the correct `UID` and `GID`.
- Pull the newest docker image: `docker-compose pull`
- Run docker: `docker-compose up`. You should see the docker being setup.
- This docker uses Jupyter notebooks, and you will see an URL once the docker is up. Please copy and paste the URL
to a web browser of your choice to access the workspace. 

##### Notes (if notebook URL does not work)
- Option1: in your `docker-compose.yaml` file, uncomment the last line under `environment` to disable token and try again
- Option2: try the 192.168.X.X host with the same token as shown in the output (X.X can be obtained by `hostname -I`)
- Option3: if you have access to docker GUI app (e.g., Kitematic for docker temrinal), try open the web page there with the token

## To run experiments
1. Run Docker and open Jupyter notebook.
2. Open terminal
3. Navigate to
```
workspace->simple_pim
```
4. Replace appropriate area and energy values for ReRAM, baseline MRAM, High Resistance (HR) MRAM, from Table 1 of the main paper in the following file:
```
PIM_estimation_tables->memristor_data->data->ReRAMcell_compute.csv
```
5. Run `run_resnet18_32x32_ks.sh` file in shell
6. Copy the results generated inside the `resnet18_32x32_fpadc_1c_ks` and `resnet18_32x32_fpadc_2c_ks` directories to the `outputs_storage` directory (already provided)
7. Repeat steps 1 to 6 for ReRAM, baseline MRAM and HR MRAM (already provided): `resnet18_32x32_ks_0.5v_mtj_mtjarea, resnet18_32x32_ks_0.5v_mtj_mtjarea_hr, resnet18_32x32_ks_0.5v_rram` inside `outputs_storage`

## To generate results
1. Copy result directories from the `resnet18_32x32_ks_0.5v_mtj_mtjarea` directory inside `outputs_storage` to the `outputs` directory
2. Run the notebook `config_resnet18_ks.ipynb`. (Note the csv file name to be saved based on the data, baseline MRAM or HR MRAM)
3. Repeat steps 1,2 for `resnet18_32x32_ks_0.5v_mtj_mtjarea_hr`
4. Now the `results_mram.csv` and `results_mram_hr.csv` files are generated (already provided)
5. Copy result directories from the `resnet18_32x32_ks_0.5v_rram` directory inside `outputs_storage` to the `outputs` directory
6. Run the notebook `config_resnet18_rram_ks.ipynb` to generate figure in the main paper

